package chess4j.board;

import chess4j.moves.Move;

public class DebugBoardImpl extends BoardImpl {
	public void applyMove(Move m) {
		if (!BoardVerifier.verifyBoard(this)) {
			System.out.println("invalid board before applyMove(): " + m.toString());
			System.exit(1);
		}
		super.applyMove(m);
		if (!BoardVerifier.verifyBoard(this)) {
			System.out.println("invalid board after applyMove(): " + m.toString());
			this.printMoves();
			System.exit(1);
		}		
	}
	
	public void printMoves() {
//		for (int i=0;i<_undoStack.size();i++) {
//			Undo u = _undoStack.get(i);
//			System.out.println(i + ": " + u.getMove());
//		}
	}

	public void undoLastMove() {
		if (!BoardVerifier.verifyBoard(this)) {
			System.out.println("invalid board before undoLastMove().");
			System.exit(1);
		}
		super.undoLastMove();
		if (!BoardVerifier.verifyBoard(this)) {
			System.out.println("invalid board after undoLastMove().");
			System.exit(1);
		}
	}
}
